﻿var version = 1.1;
/*	VERSION: 1.1
1.1		Added "preChange" event that allows event reactions to override the impending value.
1.0		---

USAGE: 
	#include "functions/announceChanges2.as"
	myVar = false;
	announceChanges2( "myVar", false, true );
	react.to("change_myVar").then = function( evt ){
		trace( "myVar is " + evt.value );
	}
	
	myVar = true;
	

PARAMETERS:
	varName								// The name of the variable to "watch"
	alwaysFire						// When TRUE, then the event will fire even if the same value is re-assigned the the variable
	announceInitialValue	// When TRUE, then the event will fire when the "init" event occurs
	
	
DESCRIPTION:
	This fires a  "change_varName"  event after the specified variable changes value.
	If the same value is re-assigned to the variable, then no event occurs.  (Unless "alwaysFire" is TRUE)
	This is accomplished using a property matching the variable's name.
*/
_this = _this || this;
#include "functions/eventSystem3.as"
if(!_this.addListener)		AsBroadcaster.initialize( _this );
if(!react)								var react = make_react( _this );		// param is optional
function onUnload(){
	sendEvent( "unload" );		// this will trigger react.unload()		... and trigger any external code listening for "unload" to occur here
}// onUnload()


function announceChanges2( varName, alwaysFire, announceInitialValue ){
	// default values of optional parameters
	if( alwaysFire === undefined )
		alwaysFire = false;
	if( announceInitialValue === undefined )
		announceInitialValue = true;
	
	
	var _variable = _this[varName];
	function get_variable(){
		return _variable;
	}
	function set_variable( newValue ){
		// ignore redundant updates / self-updates,  unless alwaysFire is TRUE
		if( !alwaysFire  &&  _variable === newValue)		return;
		// remember the new value
		_variable = newValue;
		// announce the impending value  (mutable)
		var evt = {value: newValue};
		sendEvent("preChange_" + varName, evt);
		// allow preChange_ reactions to override the assigned value
		_variable = evt.value;
		// announce the new value  (immutable)
		sendEvent("change_" + varName, evt );
	}// set()
	var propCreated = _this.addProperty( varName , get_variable, set_variable);
	
	// init => announce initial value
	if( announceInitialValue )
	{// if:  announceInitialValue is true (default)
		react.to("init").then = function(){
			sendEvent("change_"+varName, {value: _this[varName]});
		}// init()
	}// if:  announceInitialValue is true (default)
	
	
	if( propCreated === false ){
		trace( "announceChanges2() failed to turn " + varName + " into a property" );
		return;
	}
	
	
	return propCreated;
}// announceChanges2()



announceChanges2.version = version;
version = null;
delete version;